<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Superfast
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Disable thumbnail options via customizer.
$thumbnail = get_theme_mod( 'gmr_active-singlethumb', 0 );

// Disable meta data options via customizer.
$metadata = get_theme_mod( 'gmr_active-metasingle', 0 );

$postnav = get_theme_mod( 'gmr_active-postnav', 0 );

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php echo superfast_itemtype_schema( 'CreativeWork' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>

	<div class="gmr-box-content gmr-single">
	<?php
	if ( 0 === $thumbnail ) :
		if ( has_post_thumbnail() ) {
			?>
			<figure class="wp-caption alignnone">
				<?php the_post_thumbnail( 'full' ); ?>
				<?php
				$get_description = get_post( get_post_thumbnail_id() )->post_excerpt;
				if ( ! empty( $get_description ) ) :
					?>
					<figcaption class="wp-caption-text"><?php echo esc_html( $get_description ); ?></figcaption>
				<?php endif; ?>
			</figure>
			<?php
		}
	endif;
	?>

		<header class="entry-header">
			<?php the_title( '<h1 class="entry-title" ' . superfast_itemprop_schema( 'headline' ) . '>', '</h1>' ); ?>
			<?php
			if ( 0 === $metadata ) :
				gmr_posted_on();
			endif;
			?>
		</header><!-- .entry-header -->

		<div class="entry-content entry-content-single" <?php echo superfast_itemprop_schema( 'text' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
			<?php
				the_content();
			?>
		</div><!-- .entry-content -->

		<footer class="entry-footer">
			<?php gmr_entry_footer(); ?>
			<?php
			if ( 0 === $postnav ) :
				if ( ! ( is_attachment() ) ) {
					the_post_navigation(
						array(
							'prev_text' => __( '<span>Previous post</span> %title', 'superfast' ),
							'next_text' => __( '<span>Next post</span> %title', 'superfast' ),
						)
					);
				} else {
					echo '<nav class="navigation post-navigation" role="navigation">';
					echo '<h2 class="screen-reader-text">Post navigation</h2>';
						echo '<div class="nav-links">';
						previous_image_link( false, '<div class="nav-previous"><span>' . __( 'Previous Image', 'superfast' ) . '</span></div>' );
						next_image_link( false, '<div class="nav-next"><span>' . __( 'Next Image', 'superfast' ) . '</span></div>' );
						echo '</div>';
					echo '</nav>';
				}
			endif;
			?>
		</footer><!-- .entry-footer -->

	</div><!-- .gmr-box-content -->
	<?php do_action( 'idblog_core_author_box' ); ?>
	<?php
		if ( comments_open() || get_comments_number() ) :
			/* Add Non AMP Version using <div id="site-version-switcher"> and id="version-switch-link" */
			$nonamp_link = amp_remove_endpoint( amp_get_current_url() );
			echo '<div class="site-main gmr-box-content text-center"><div id="site-version-switcher"><a id="version-switch-link" class="button" href="' . esc_url( $nonamp_link ) . '#comments" class="amp-wp-canonical-link" title="' . __( 'Add Comment', 'superfast' ) . '" rel="noamphtml nofollow">' . __( 'Add Comment', 'superfast' ) . '</a></div></div>';
		endif;
	?>
</article><!-- #post-## -->
