<?php
/**
 * Social share fearures.
 *
 * Author: Gian MR - http://www.gianmr.com
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'idblog_core_share_default' ) ) :
	/**
	 * Insert social share from plugin
	 *
	 * @since 1.0.0
	 * @param string $output Output.
	 * @return string @output
	 */
	function idblog_core_share_default( $output = null ) {

		$idblg_social = get_option( 'idblg_social' );

		if ( isset( $idblg_social['enable_socialshare'] ) && ! empty( $idblg_social['enable_socialshare'] ) ) {
			// option, section, default.
			$option = $idblg_social['enable_socialshare'];
		} else {
			$option = 'on';
		}

		if ( 'on' === $option ) {

			$filter_title = str_replace( ' ', '%20', get_the_title() );

			$output  = '';
			$output .= '<div class="idblog-social-share">';
			$output .= '<h3>' . __( 'Share this:', 'idblog-core' ) . '</h3>';
			$output .= '<ul class="idblog-socialicon-share">';
			$output .= '<li class="facebook">';
			$output .= '<a href="https://www.facebook.com/sharer/sharer.php?u=' . get_the_permalink() . '" class="idblog-sharebtn idblog-facebook" target="_blank" rel="nofollow" title="' . __( 'Share this', 'idblog-core' ) . '">';
			$output .= __( 'Facebook', 'idblog-core' );
			$output .= '</a>';
			$output .= '</li>';
			$output .= '<li class="twitter">';
			$output .= '<a href="https://twitter.com/share?url=' . get_the_permalink() . '&amp;text=' . $filter_title . '" class="idblog-sharebtn idblog-twitter" target="_blank" rel="nofollow" title="' . __( 'Tweet this', 'idblog-core' ) . '">';
			$output .= __( 'Tweet', 'idblog-core' );
			$output .= '</a>';
			$output .= '</li>';
			$output .= '<li class="whatsapp">';
			$output .= '<a href="https://api.whatsapp.com/send?text=' . $filter_title . '%20' . rawurlencode( esc_url( get_permalink() ) ) . '" class="idblog-sharebtn idblog-whatsapp" target="_blank" rel="nofollow" title="' . __( 'WhatsApp this', 'idblog-core' ) . '">';
			$output .= __( 'WhatsApp', 'idblog-core' );
			$output .= '</a>';
			$output .= '</li>';
			$output .= '</ul>';
			$output .= '</div>';

		}

		return $output;

	}
endif; // endif idblog_core_share_default.

if ( ! function_exists( 'idblog_core_share_jetpack' ) ) :
	/**
	 * Insert social share in jetpack.
	 */
	function idblog_core_share_jetpack() {
		$share = '';
		if ( function_exists( 'sharing_display' ) ) {
			$share .= sharing_display( '', false );
		} else {
			$share .= idblog_core_share_default();
		}

		if ( class_exists( 'Jetpack_Likes' ) ) {
			$custom_likes = new Jetpack_Likes;
			$share       .= $custom_likes->post_likes( '' );
		}
		return $share;
	}
endif; // endif idblog_core_share_jetpack.

if ( ! function_exists( 'idblog_core_add_share_the_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @link https://jetpack.com/support/related-posts/customize-related-posts/#delete
	 * @param string $content Content.
	 * @return string $content
	 */
	function idblog_core_add_share_the_content( $content ) {
		if ( is_single() && in_the_loop() ) {
			$content = $content . idblog_core_share_jetpack();
		}
		return $content;
	}
endif; // endif idblog_core_add_share_the_content.
add_filter( 'the_content', 'idblog_core_add_share_the_content', 30 );
