<?php
/**
 * Related Post Features
 *
 * Author: Gian MR - http://www.gianmr.com
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'idblog_related_post' ) ) {
	/**
	 * Adding the related post to the end of your single post
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function idblog_related_post() {
		global $post;
		$idblg_relpost = get_option( 'idblg_relpost' );

		if ( isset( $idblg_relpost['relpost_number'] ) && ! empty( $idblg_relpost['relpost_number'] ) ) {
			// option, section, default.
			$number = intval( $idblg_relpost['relpost_number'] );
		} else {
			$number = 3;
		}

		if ( isset( $idblg_relpost['relpost_taxonomy'] ) && 'tags' === $idblg_relpost['relpost_taxonomy'] ) {
			$tags = wp_get_post_tags( $post->ID );
			if ( $tags ) {
				$tag_ids = array();

				foreach ( $tags as $individual_tag ) {
					$tag_ids[] = $individual_tag->term_id;

					$args = array(
						'tag__in'             => $tag_ids,
						'post__not_in'        => array( $post->ID ),
						'posts_per_page'      => $number,
						'ignore_sticky_posts' => 1,
					);
				}
			}
		} else {
			$categories = get_the_category( $post->ID );
			if ( $categories ) {
				$category_ids = array();
				foreach ( $categories as $individual_category ) {
					$category_ids[] = $individual_category->term_id;

					$args = array(
						'category__in'        => $category_ids,
						'post__not_in'        => array( $post->ID ),
						'posts_per_page'      => $number,
						'ignore_sticky_posts' => 1,
					);
				}
			}
		}

		if ( ! isset( $args ) ) {
			$args = '';
		}
		$idblog_query = new WP_Query( $args );

		$content = '';
		$i       = 1;
		if ( $idblog_query->have_posts() ) {

			$content .= '<div class="idblog-related-post idblog-core">';

			$content .= '<h3 class="related-title">' . __( 'Related posts:', 'idblog-core' ) . '</h3>';

			$content .= '<div class="row">';

			while ( $idblog_query->have_posts() ) :
				$idblog_query->the_post();

				$content           .= '<div class="idblog-wrap-relpost col-md-4">';
				$featured_image_url = wp_get_attachment_url( get_post_thumbnail_id( $post->ID ) );
				if ( ! empty( $featured_image_url ) ) :
					$content .= '<a href="' . get_permalink() . '" itemprop="url" title="' . the_title_attribute(
						array(
							'before' => __( 'Permalink to: ', 'idblog-core' ),
							'after'  => '',
							'echo'   => false,
						)
					) . '" rel="bookmark">';
					$content .= get_the_post_thumbnail( $post->ID, 'medium', array( 'itemprop' => 'image' ) );
					$content .= '</a>';
				endif;
					$content .= '<p>';
					$content .= '<a href="' . get_permalink() . '" itemprop="url" title="' . the_title_attribute(
						array(
							'before' => __( 'Permalink to: ', 'idblog-core' ),
							'after'  => '',
							'echo'   => false,
						)
					) . '" rel="bookmark">' . get_the_title() . '</a>';
					$content .= '</p>';
				$content     .= '</div>';
				if ( $i%3 == 0 ) :
					$content .= '<div class="clearfix"></div>';
				endif;
				$i++;
			endwhile;
			wp_reset_postdata();

			$content .= '</div>';

			$content .= '</div>';
		} // if have posts

		return $content;
	}
}

if ( ! function_exists( 'idblog_core_related_post' ) ) :
	/**
	 * Insert related post in functions
	 */
	function idblog_core_related_post() {
		if ( class_exists( 'Jetpack_RelatedPosts' ) ) {
			$related  = '<div class="salespro-core gmr-box-content">';
			$related .= do_shortcode( '[jetpack-related-posts]' );
			$related .= '</div>';
		} else {
			$related = idblog_related_post();
		}
		return $related;
	}
endif; // endif idblog_core_related_post.

if ( ! function_exists( 'idblog_core_add_related_the_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @link https://jetpack.com/support/related-posts/customize-related-posts/#delete
	 * @param string $content content.
	 * @return string
	 */
	function idblog_core_add_related_the_content( $content ) {
		if ( is_single() && in_the_loop() ) {
			$idblg_relpost = get_option( 'idblg_relpost' );
			if ( isset( $idblg_relpost['enable_relpost'] ) && ! empty( $idblg_relpost['enable_relpost'] ) ) {
				// option, section, default.
				$option = $idblg_relpost['enable_relpost'];
			} else {
				$option = 'on';
			}

			if ( 'on' === $option ) :
				$content = $content . idblog_core_related_post();
			else :
				$content = $content;
			endif;
		}
		return $content;
	}
endif; // endif idblog_core_add_related_the_content.
add_filter( 'the_content', 'idblog_core_add_related_the_content', 40 );
