<?php
/**
 * FB comments template file.
 * This replaces the theme's comment template when fb comments are enable
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$idblg_social = get_option( 'idblg_social' );

if ( isset( $idblg_social['social_app_id_facebook'] ) && ! empty( $idblg_social['social_app_id_facebook'] ) ) {
	// option, section, default.
	$appid = $idblg_social['social_app_id_facebook'];
} else {
	$appid = '1703072823350490';
}
?>
<div id="fb-root"></div>
<script>(function(d, s, id) {
	var js, fjs = d.getElementsByTagName(s)[0];
	if (d.getElementById(id)) return;
	js = d.createElement(s); js.id = id;
	js.src = "//connect.facebook.net/<?php bloginfo( 'language' ); ?>/sdk.js#xfbml=1&appId=<?php echo esc_html( $appid ); ?>&version=v2.8";
	fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));</script>
<div id="comments" class="idblog-fb-comments">
	<div class="fb-comments" data-href="<?php the_permalink(); ?>" data-numposts="5" data-width="100%"></div>
</div>
