<?php
/**
 * Banner features
 *
 * Author: Gian MR - http://www.gianmr.com
 *
 * @since 1.0.0
 * @package Idblog Core
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'idblog_core_top_banner' ) ) {
	/**
	 * Adding banner at top via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_top_banner() {
		$idblg_ads = get_option( 'idblg_ads' );
		$idblg_amp = get_option( 'idblg_amp' );
		if ( idblog_core_is_amp() ) {
			if ( isset( $idblg_amp['amp_ads_topbanner'] ) && ! empty( $idblg_amp['amp_ads_topbanner'] ) ) {
				echo '<div class="idblog-topbanner-amp">';
				echo do_shortcode( $idblg_amp['amp_ads_topbanner'] );
				echo '</div>';
			}
		} else {
			if ( isset( $idblg_ads['ads_topbanner'] ) && ! empty( $idblg_ads['ads_topbanner'] ) ) {
				echo '<div class="idblog-topbanner">';
				echo do_shortcode( $idblg_ads['ads_topbanner'] );
				echo '</div>';
			}
		}
	}
}
add_action( 'idblog_core_top_banner', 'idblog_core_top_banner', 10 );

if ( ! function_exists( 'idblog_core_top_banner_after_menu' ) ) {
	/**
	 * Adding banner at top via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_top_banner_after_menu() {
		$idblg_ads = get_option( 'idblg_ads' );
		$idblg_amp = get_option( 'idblg_amp' );
		if ( idblog_core_is_amp() ) {
			if ( isset( $idblg_amp['amp_ads_topbanner_aftermenu'] ) && ! empty( $idblg_amp['amp_ads_topbanner_aftermenu'] ) ) {
				echo '<div class="container">';
					echo '<div class="idblog-topbanner-aftermenu">';
					echo do_shortcode( $idblg_amp['amp_ads_topbanner_aftermenu'] );
					echo '</div>';
				echo '</div>';
			}
		} else {
			if ( isset( $idblg_ads['ads_topbanner_aftermenu'] ) && ! empty( $idblg_ads['ads_topbanner_aftermenu'] ) ) {
				echo '<div class="container">';
					echo '<div class="idblog-topbanner-aftermenu">';
					echo do_shortcode( $idblg_ads['ads_topbanner_aftermenu'] );
					echo '</div>';
				echo '</div>';
			}
		}
	}
}
add_action( 'idblog_core_top_banner_after_menu', 'idblog_core_top_banner_after_menu', 10 );

if ( ! function_exists( 'idblog_core_banner_before_content' ) ) {

	/**
	 * Adding banner at before content via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_banner_before_content() {
		$idblg_ads = get_option( 'idblg_ads' );
		$idblg_amp = get_option( 'idblg_amp' );
		if ( isset( $idblg_ads['ads_before_content_position'] ) && 'left' === $idblg_ads['ads_before_content_position'] ) {
			$class = ' pull-left';
		} elseif ( isset( $idblg_ads['ads_before_content_position'] ) && 'right' === $idblg_ads['ads_before_content_position'] ) {
			$class = ' pull-right';
		} elseif ( isset( $idblg_ads['ads_before_content_position'] ) && 'center' === $idblg_ads['ads_before_content_position'] ) {
			$class = ' idblog-center-ads';
		} else {
			$class = '';
		}

		if ( idblog_core_is_amp() ) {
			if ( isset( $idblg_amp['amp_ads_before_content'] ) && ! empty( $idblg_amp['amp_ads_before_content'] ) ) {
				echo '<div class="idblog-banner-beforecontent idblog-center-ads">';
				echo do_shortcode( $idblg_amp['amp_ads_before_content'] );
				echo '</div>';
			}
		} else {
			if ( isset( $idblg_ads['ads_before_content'] ) && ! empty( $idblg_ads['ads_before_content'] ) ) {
				echo '<div class="idblog-banner-beforecontent' . esc_html( $class ) . '">';
				echo do_shortcode( $idblg_ads['ads_before_content'] );
				echo '</div>';
			}
		}

	}
}

if ( ! function_exists( 'idblog_core_add_banner_before_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @param string $content Content.
	 * @return string $content
	 */
	function idblog_core_add_banner_before_content( $content ) {
		if ( is_singular( array( 'post' ) ) && in_the_loop() ) {
			$content = idblog_core_banner_before_content() . $content;
		}
		return $content;
	}

endif; // endif idblog_core_add_banner_before_content.
add_filter( 'the_content', 'idblog_core_add_banner_before_content', 30, 1 );

if ( ! function_exists( 'idblog_core_banner_after_content' ) ) {

	/**
	 * Adding banner at before content via hook
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function idblog_core_banner_after_content() {
		$idblg_ads = get_option( 'idblg_ads' );
		$idblg_amp = get_option( 'idblg_amp' );
		$banner    = '';
		if ( isset( $idblg_ads['ads_after_content_position'] ) && 'right' === $idblg_ads['ads_after_content_position'] ) {
			$class = ' idblog-center-right';
		} elseif ( isset( $idblg_ads['ads_after_content_position'] ) && 'center' === $idblg_ads['ads_after_content_position'] ) {
			$class = ' idblog-center-ads';
		} else {
			$class = '';
		}
		if ( idblog_core_is_amp() ) {
			if ( isset( $idblg_amp['amp_ads_after_content'] ) && ! empty( $idblg_amp['amp_ads_after_content'] ) ) {
				$banner .= '<div class="idblog-banner-aftercontent idblog-center-ads">';
				$banner .= do_shortcode( $idblg_amp['amp_ads_after_content'] );
				$banner .= '</div>';
			}
		} else {
			if ( isset( $idblg_ads['ads_after_content'] ) && ! empty( $idblg_ads['ads_after_content'] ) ) {
				$banner .= '<div class="idblog-banner-aftercontent' . esc_html( $class ) . '">';
				$banner .= do_shortcode( $idblg_ads['ads_after_content'] );
				$banner .= '</div>';
			}
		}
		return $banner;
	}
}

if ( ! function_exists( 'idblog_core_add_banner_after_content' ) ) :
	/**
	 * Insert content after box content single
	 *
	 * @since 1.0.0
	 * @param string $content Content.
	 * @return string $content
	 */
	function idblog_core_add_banner_after_content( $content ) {
		if ( is_singular( array( 'post' ) ) && in_the_loop() ) {
			$content = $content . idblog_core_banner_after_content();
		}
		return $content;
	}
endif; // endif idblog_core_add_banner_after_content.
add_filter( 'the_content', 'idblog_core_add_banner_after_content', 30 );

if ( ! function_exists( 'idblog_core_helper_after_paragraph' ) ) :
	/**
	 * Helper add content after paragprah
	 *
	 * @param String $insertion Code.
	 * @param Number $paragraph_id ID Paraghrap.
	 * @param String $content Code.
	 * @since 1.0.0
	 * @link http://stackoverflow.com/questions/25888630/place-ads-in-between-text-only-paragraphs
	 * @return string
	 */
	function idblog_core_helper_after_paragraph( $insertion, $paragraph_id, $content ) {
		if ( is_singular( array( 'post' ) ) && in_the_loop() ) {

			$closing_p  = '</p>';
			$paragraphs = explode( $closing_p, wptexturize( $content ) );
			$count      = count( $paragraphs );

			foreach ( $paragraphs as $index => $paragraph ) {
				$word_count = count( explode( ' ', $paragraph ) );
				if ( trim( $paragraph ) && $paragraph_id == $index + 1 ) {
					$paragraphs[ $index ] .= $closing_p;
				}
				if ( $paragraph_id == $index + 1 && $count >= 4 ) {
					$paragraphs[ $index ] .= $insertion;
				}
			}
		}
		return implode( '', $paragraphs );
	}
endif; // endif idblog_core_helper_after_paragraph.

if ( ! function_exists( 'idblog_core_add_banner_inside_content' ) ) :
	/**
	 * Insert content inside content single
	 *
	 * @since 1.0.0
	 * @param string $content Content.
	 * @return string $content
	 */
	function idblog_core_add_banner_inside_content( $content ) {
		$idblg_ads = get_option( 'idblg_ads' );
		$idblg_amp = get_option( 'idblg_amp' );
		if ( isset( $idblg_ads['ads_inside_content_position'] ) && 'right' === $idblg_ads['ads_inside_content_position'] ) {
			$class = ' idblog-center-right';
		} elseif ( isset( $idblg_ads['ads_inside_content_position'] ) && 'center' === $idblg_ads['ads_inside_content_position'] ) {
			$class = ' idblog-center-ads';
		} else {
			$class = '';
		}
		if ( idblog_core_is_amp() ) {
			if ( isset( $idblg_amp['amp_ads_inside_content'] ) && ! empty( $idblg_amp['amp_ads_inside_content'] ) ) {
				$ad_code = '<div class="idblog-banner-insidecontent idblog-center-ads">' . do_shortcode( $idblg_amp['amp_ads_inside_content'] ) . '</div>';
				if ( is_singular( array( 'post' ) ) && in_the_loop() ) {
					return idblog_core_helper_after_paragraph( $ad_code, 2, $content );
				}
			}
		} else {
			if ( isset( $idblg_ads['ads_inside_content'] ) && ! empty( $idblg_ads['ads_inside_content'] ) ) {
				$ad_code = '<div class="idblog-banner-insidecontent' . esc_html( $class ) . '">' . do_shortcode( $idblg_ads['ads_inside_content'] ) . '</div>';
				if ( is_singular( array( 'post' ) ) && in_the_loop() ) {
					return idblog_core_helper_after_paragraph( $ad_code, 2, $content );
				}
			}
		}
		return $content;
	}
endif; // endif idblog_core_add_banner_inside_content.
add_filter( 'the_content', 'idblog_core_add_banner_inside_content' );

if ( ! function_exists( 'idblog_core_floating_banner_left' ) ) {

	/**
	 * Adding banner at top via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_floating_banner_left() {
		$idblg_ads = get_option( 'idblg_ads' );

		if ( isset( $idblg_ads['ads_floatbanner_left'] ) && ! empty( $idblg_ads['ads_floatbanner_left'] ) ) {
			echo '<div class="idblog-floatbanner idblog-floatbanner-left">';
				echo '<div class="inner-float-left">';
				echo '<button onclick="parentNode.remove()" title="' . esc_html__( 'close', 'idblog-core' ) . '">' . esc_html__( 'close', 'idblog-core' ) . '</button>';
				echo do_shortcode( $idblg_ads['ads_floatbanner_left'] );
				echo '</div>';
			echo '</div>';
		}
	}
}
add_action( 'idblog_core_floating_banner_left', 'idblog_core_floating_banner_left', 10 );

if ( ! function_exists( 'idblog_core_floating_banner_right' ) ) {

	/**
	 * Adding floating banner
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_floating_banner_right() {
		$idblg_ads = get_option( 'idblg_ads' );

		if ( isset( $idblg_ads['ads_floatbanner_right'] ) && ! empty( $idblg_ads['ads_floatbanner_right'] ) ) {
			echo '<div class="idblog-floatbanner idblog-floatbanner-right">';
				echo '<div class="inner-float-right">';
				echo '<button onclick="parentNode.remove()" title="' . esc_html__( 'close', 'idblog-core' ) . '">' . esc_html__( 'close', 'idblog-core' ) . '</button>';
				echo do_shortcode( $idblg_ads['ads_floatbanner_right'] );
				echo '</div>';
			echo '</div>';
		}
	}
}
add_action( 'idblog_core_floating_banner_right', 'idblog_core_floating_banner_right', 15 );

if ( ! function_exists( 'idblog_core_floating_banner_footer' ) ) {

	/**
	 * Adding floating banner
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_floating_banner_footer() {
		$idblg_ads = get_option( 'idblg_ads' );

		if ( isset( $idblg_ads['ads_floatbanner_footer'] ) && ! empty( $idblg_ads['ads_floatbanner_footer'] ) ) {

			echo '<div class="idblog-floatbanner idblog-floatbanner-footer">';
				echo '<div class="container">';
					echo '<div class="inner-floatbanner-bottom">';
					echo '<button onclick="parentNode.remove()" title="' . esc_html__( 'close', 'idblog-core' ) . '">' . esc_html__( 'close', 'idblog-core' ) . '</button>';
					echo do_shortcode( $idblg_ads['ads_floatbanner_footer'] );
					echo '</div>';
				echo '</div>';
			echo '</div>';

		}
	}
}
add_action( 'idblog_core_floating_footer', 'idblog_core_floating_banner_footer', 20 );

if ( ! function_exists( 'idblog_core_banner_footer' ) ) {

	/**
	 * Adding banner at footer via hook
	 *
	 * @since 1.0.0
	 * @return void
	 */
	function idblog_core_banner_footer() {
		$idblg_ads = get_option( 'idblg_ads' );

		if ( isset( $idblg_ads['ads_footerbanner'] ) && ! empty( $idblg_ads['ads_footerbanner'] ) ) {
			echo '<div class="container">';
				echo '<div class="idblog-footerbanner">';
				echo do_shortcode( $idblg_ads['ads_footerbanner'] );
				echo '</div>';
			echo '</div>';
		}
	}
}
add_action( 'idblog_core_banner_footer', 'idblog_core_banner_footer', 10 );

if ( ! function_exists( 'idblog_core_banner_between_posts' ) ) {

	/**
	 * Adding banner between posts in archive and index post
	 *
	 * @since 1.0.5
	 * @return void
	 */
	function idblog_core_banner_between_posts() {
		global $wp_query;

		$idblg_ads = get_option( 'idblg_ads' );
		$idblg_amp = get_option( 'idblg_amp' );
		if ( isset( $idblg_ads['ads_after_betweenpost_position'] ) && '2' === $idblg_ads['ads_after_betweenpost_position'] ) {
			$numb = 1;
		} elseif ( isset( $idblg_ads['ads_after_betweenpost_position'] ) && '3' === $idblg_ads['ads_after_betweenpost_position'] ) {
			$numb = 2;
		} elseif ( isset( $idblg_ads['ads_after_betweenpost_position'] ) && '4' === $idblg_ads['ads_after_betweenpost_position'] ) {
			$numb = 3;
		} else {
			$numb = 0;
		}

		// Check if we're at the right position and option not empty.
		if ( $wp_query->current_post === intval( $numb ) ) {
			if ( idblog_core_is_amp() ) {
				if ( isset( $idblg_amp['amp_ads_after_betweenpost'] ) && ! empty( $idblg_amp['amp_ads_after_betweenpost'] ) ) {
					// Display the banner.
					echo '<div class="gmr-masonry-banner item">';
					echo '<div class="gmr-box-content">';
						echo do_shortcode( $idblg_amp['amp_ads_after_betweenpost'] );
					echo '</div>';
					echo '</div>';

				}
			} else {
				if ( isset( $idblg_ads['ads_after_betweenpost'] ) && ! empty( $idblg_ads['ads_after_betweenpost'] ) ) {
					// Display the banner.
					echo '<div class="gmr-masonry-banner item">';
					echo '<div class="gmr-box-content">';
						echo do_shortcode( $idblg_ads['ads_after_betweenpost'] );
					echo '</div>';
					echo '</div>';

				}
			}
		}
	}
}
add_action( 'idblog_core_banner_between_posts', 'idblog_core_banner_between_posts' );
