<?php
/**
 * Plugin Name: Idblog Core
 * Plugin URI: http://www.idtheme.com
 * Description: Idblog Core - Add functionally to blog theme for easy maintenance. This plugin using only for theme with blog type from idtheme.com
 * Author: Gian Mokhammad R
 *
 * @package Idblog Core
 * Version: 2.0.7
 * Author URI: http://www.gianmr.com
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * If using amp endpoint
 *
 * @since v.1.1.3
 */
function idblog_core_is_amp() {
	return function_exists( 'is_amp_endpoint' ) && is_amp_endpoint();
}

if ( ! class_exists( 'Idblog_Core_Init' ) ) {
	/**
	 * Main Plugin Class
	 */
	class Idblog_Core_Init {

		/**
		 * Contract
		 *
		 * @since 1.0.0
		 * @access public
		 */
		public function __construct() {
			// Define.
			define( 'IDBLOG_CORE_VER', '2.0.7' );
			define( 'IDBLOG_CORE_DIRNAME', dirname( __FILE__ ) );
			define( 'IDBLOG_CORE_URL', plugin_dir_url( __FILE__ ) );

			// Include widget.
			include IDBLOG_CORE_DIRNAME . '/widgets/feedburner-widget.php';
			include IDBLOG_CORE_DIRNAME . '/widgets/custom-form-widget.php';
			include IDBLOG_CORE_DIRNAME . '/widgets/recent-posts-widget.php';

			// Include library.
			include IDBLOG_CORE_DIRNAME . '/lib/breadcrumbs.php';
			include IDBLOG_CORE_DIRNAME . '/lib/banner.php';
			include IDBLOG_CORE_DIRNAME . '/lib/external/class.settings-api.php';
			include IDBLOG_CORE_DIRNAME . '/lib/setting.idblog-core.php';
			include IDBLOG_CORE_DIRNAME . '/lib/authorbox.php';
			include IDBLOG_CORE_DIRNAME . '/lib/share.php';
			include IDBLOG_CORE_DIRNAME . '/lib/relatedpost.php';
			include IDBLOG_CORE_DIRNAME . '/lib/headfooterscript.php';
			include IDBLOG_CORE_DIRNAME . '/lib/jetpack.php';
			include IDBLOG_CORE_DIRNAME . '/lib/faster.php';

			// Action.
			add_action( 'plugins_loaded', array( $this, 'idblog_core_load_textdomain' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'register_scripts' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'idblog_core_autbox_style' ) );

			// Enable the use of shortcodes in text widgets.
			add_filter( 'widget_text', 'do_shortcode' );

			$idblg_social = get_option( 'idblg_social' );

			if ( isset( $idblg_social['enable_fb_comment'] ) && ! empty( $idblg_social['enable_fb_comment'] ) ) {
				// option, section, default.
				$option = $idblg_social['enable_fb_comment'];
			} else {
				$option = 'off';
			}

			// if option on then using fb comment.
			if ( 'on' === $option ) {
				add_filter( 'comments_template', array( $this, 'fb_comments_template' ), 20 );
			}

		}

		/**
		 * Activated plugin
		 *
		 * @since 1.0.0
		 * @access public
		 */
		public static function idblog_core_activate() {
			// nothing to do yet.
		}

		/**
		 * Deativated plugin
		 *
		 * @since 1.0.0
		 * @access public
		 */
		public static function idblog_core_deactivate() {
			// nothing to do yet.
		}

		/**
		 * Fb comment
		 *
		 * @since 1.0.2
		 * @access public
		 */
		public function fb_comments_template() {
			return IDBLOG_CORE_DIRNAME . '/lib/fb-comment.php';
		}

		/**
		 * Enqueue assets
		 *
		 * @since 1.0.0
		 * @access public
		 */
		public function register_scripts() {

			wp_register_style( 'idblog-core', IDBLOG_CORE_URL . 'css/idblog-core.css', '', '1.0.0' );
			wp_enqueue_style( 'idblog-core' );
		}

		/**
		 * Load languange
		 *
		 * @since 1.0.0
		 * @access public
		 */
		public function idblog_core_load_textdomain() {
			load_plugin_textdomain( 'idblog-core', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
			/**
			 * Class_exists on plugin working if using plugins_loaded filter
			 * Most view widget exist if wp postview plugin installed
			 */
			if ( class_exists( 'WP_Widget_PostViews' ) ) {
				include_once IDBLOG_CORE_DIRNAME . '/widgets/mostview-posts-widget.php';
			}
		}

		/**
		 * Inline Style
		 *
		 * @since 1.0.0
		 * @access public
		 */
		public function idblog_core_autbox_style() {
			if ( ! is_single() && ! is_author() && ! is_archive() ) {
				return;
			}

			$idblg_authox = get_option( 'idblg_autbox' );

			if ( isset( $idblg_authox['uname_color'] ) && ! empty( $idblg_authox['uname_color'] ) ) {
				// option, section, default.
				$username_color = $idblg_authox['uname_color'];
			} else {
				$username_color = '#222222';
			}

			if ( isset( $idblg_authox['desc_color'] ) && ! empty( $idblg_authox['desc_color'] ) ) {
				$description_color = $idblg_authox['desc_color'];
			} else {
				$description_color = '#aaaaaa';
			}

			if ( isset( $idblg_authox['web_color'] ) && ! empty( $idblg_authox['web_color'] ) ) {
				$website_color = $idblg_authox['web_color'];
			} else {
				$website_color = '#dddddd';
			}

			$style = '';
			// Username color.
			if ( isset( $username_color ) ) {
				$style .= '.gmr-ab-authorname span.uname a{color:' . esc_html( $username_color ) . ' !important;}';
			}

			// Description color.
			if ( isset( $description_color ) ) {
				$style .= '.gmr-ab-desc {color:' . esc_html( $description_color ) . ' !important;}';
			}

			// Website color.
			if ( isset( $website_color ) ) {
				$style .= '.gmr-ab-web a{color:' . esc_html( $website_color ) . ' !important;}';
			}

			wp_add_inline_style( 'idblog-core', $style );
		}
	}
}


if ( class_exists( 'Idblog_Core_Init' ) ) {
	// Installation and uninstallation hooks.
	register_activation_hook( __FILE__, array( 'Idblog_Core_Init', 'idblog_core_activate' ) );
	register_deactivation_hook( __FILE__, array( 'Idblog_Core_Init', 'idblog_core_deactivate' ) );

	// Initialise Class.
	$idblog_core_init_by_gianmr = new Idblog_Core_Init();

	// Other functionally.
	require IDBLOG_CORE_DIRNAME . '/lib/update/plugin-update-checker.php';
	$MyUpdateChecker = PucFactory::buildUpdateChecker(
		'https://www.kentooz.com/files/idblog-core/idblcorouripnangselokan.json',
		__FILE__,
		'idblog-core'
	);
}
